//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "Unit1.h"
#include "GLWektory.h"
#include "Teksturowanie.h"
#include "GLNapisy.h"

#include <Jpeg.hpp>

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TGLForm(Owner)
{
   ObslugaMyszy=true;
   KolorTla=clBlack;
   debug_mode=false;
   Mgla=false;
   NieruchomyPokoj=false;
   NieruchomyPokoj_Kolor=clBlue;
   NatezenieSwiatlaOtoczenia=0.5f;
   SwobodneObroty=true;
   SwobodneObrotyWygaszanie=0.0f;

   Obracaj(10.0f,0.0f,0.0f);

   Caption=(AnsiString)"GLForm, OpenGL "+(char*)glGetString(GL_VERSION);

   //teksturowanie sfery
   czyTeksturowacSfere=true;
   glEnable(GL_TEXTURE_2D);

   int TeksturaSzer,TeksturaWys;
   unsigned long* Tekstura=WczytajTeksture("tekstura.jpg",TeksturaSzer,TeksturaWys);
   if (Tekstura!=NULL)
   {
      glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
      glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
      gluBuild2DMipmaps(GL_TEXTURE_2D, 3,TeksturaSzer,TeksturaWys,GL_RGBA,GL_UNSIGNED_BYTE,Tekstura);
      delete[] Tekstura; //oryginalne dane sa usuwane
   }
}

//---------------------------------------------------------------------------

void __fastcall TForm1::RysujScene()
{
   float rozmiar=1.0f;
   RysujGLU(rozmiar);
}


void __fastcall TForm1::RysujGLU(float rozmiar)
{
   glColor4ub(255,255,255,255);
   glRotatef(90.0f,1.0f,0.0f,0.0f);
   GLUquadricObj* kwadryka=gluNewQuadric(); //tworzenie obiektu kwadryki
   gluQuadricDrawStyle(kwadryka,GLU_FILL); //ustalenie stylu

   if (czyTeksturowacSfere) gluQuadricTexture(kwadryka,GL_TRUE);
   gluSphere(kwadryka,rozmiar,30,30); //rysowanie
   gluQuadricTexture(kwadryka,GL_FALSE);
   gluDeleteQuadric(kwadryka); //usuwanie obiektu
}

//---------------------------------------------------------------------------

void __fastcall TForm1::FormKeyDown(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
   //obroty
   if (Shift.Empty())
   {
      if (Key>='0' && Key<='7')
      {
         GLenum swiatlo=GL_LIGHT0;
         switch (Key)
         {
            case '1': swiatlo=GL_LIGHT1; break;
            case '2': swiatlo=GL_LIGHT2; break;
            case '3': swiatlo=GL_LIGHT3; break;
            case '4': swiatlo=GL_LIGHT4; break;
            case '5': swiatlo=GL_LIGHT5; break;
            case '6': swiatlo=GL_LIGHT6; break;
            case '7': swiatlo=GL_LIGHT7; break;
            default: swiatlo=GL_LIGHT0;
         }
         if (glIsEnabled(swiatlo)) glDisable(swiatlo);
         else glEnable(swiatlo);
      }

      switch (Key)
      {
         case 'b':
         case 'B':
            if (glIsEnabled(GL_BLEND)) glDisable(GL_BLEND);
            else glEnable(GL_BLEND);
            break;
         case 'a':
         case 'A':
            if (glIsEnabled(GL_POINT_SMOOTH))
            {
               glDisable(GL_POINT_SMOOTH);
               glDisable(GL_LINE_SMOOTH);
               glDisable(GL_POLYGON_SMOOTH);
            }
            else
            {
               glEnable(GL_POINT_SMOOTH);
               glEnable(GL_LINE_SMOOTH);
               glEnable(GL_POLYGON_SMOOTH);
            }
            break;

         case 'm':
         case 'M':
            Mgla=!Mgla;
            break;

         case 'n':
         case 'N':
            NieruchomyPokoj=!NieruchomyPokoj;
            break;

         case 't':
         case 'T':
            Teksturowanie=!Teksturowanie;
            break;

         case 'i':
         case 'I':
            czyTeksturowacSfere=!czyTeksturowacSfere;
            break;

         case VK_OEM_MINUS:
            NatezenieSwiatlaOtoczenia-=0.01;
            break;
         case VK_OEM_PLUS:
         case '=':
            NatezenieSwiatlaOtoczenia+=0.01;
            break;
      }
   }

   GL_RysujScene();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Oswietlenie()
{
   MlecznaZarowka();
   //ZoltaIZielonaMleczneZarowki();
   Reflektor();
}

void __fastcall TForm1::MlecznaZarowka()
{
   const float kolor1_rozproszone[]={0.5,0.5,0.5,1.0};
   glLightfv(GL_LIGHT1,GL_DIFFUSE,kolor1_rozproszone);
   glEnable(GL_LIGHT1);
}

void __fastcall TForm1::ZoltaIZielonaMleczneZarowki()
{
   //zolta mleczna zarowka
	const float kolor_rozproszone_zolta[4]={1.0f,1.0f,0.0f,1.0f};
	const float pozycja_zolta[4]={-2.0f,0.0f,1.0f,1.0f};

	glLightfv(GL_LIGHT2,GL_POSITION,pozycja_zolta);
	glLightfv(GL_LIGHT2,GL_DIFFUSE,kolor_rozproszone_zolta);
	glEnable(GL_LIGHT2);

   //zielona mleczna zarowka
	const float kolor_rozproszone_zielony[4]={0.0f,1.0f,0.0f,1.0f};
	const float pozycja_zielony[4]={2.0f,0.0f,1.0f,1.0f};

	glLightfv(GL_LIGHT3,GL_POSITION,pozycja_zielony);
	glLightfv(GL_LIGHT3,GL_DIFFUSE,kolor_rozproszone_zielony);
	glEnable(GL_LIGHT3);
}

void __fastcall TForm1::Reflektor()
{
   const float kolor_rozproszone[4]={0.3,0.3,0.3,1.0};
   const float kolor_reflektora[4]={1.0,1.0,1.0,1.0};
   const float pozycja[4]={0.0,-10.0,10.0,1.0};
   //const float pozycja[4]={2.0f,2.0f,-2.0f,1.0f};
   const szerokosc_wiazki=60.0; //w stopniach
   glLightfv(GL_LIGHT4,GL_POSITION,pozycja);
   glLightfv(GL_LIGHT4,GL_DIFFUSE,kolor_rozproszone);
   glLightfv(GL_LIGHT4,GL_SPECULAR,kolor_reflektora);
   glLightf(GL_LIGHT4,GL_SPOT_CUTOFF,szerokosc_wiazki);
   glEnable(GL_LIGHT4);
}



